/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"
#include "Buttons.h"
#include "STM32DesignChallenge.h"

/* External functions --------------------------------------------------------*/

// Buttons_Init()
// --------------
// Initialize the button module.
extern void Buttons_Init()
{
	/* we use the DesignChallenge button (PA0) -------------------------------*/
	STM32designchallenge_PBInit(BUTTON_USER, BUTTON_MODE_GPIO);

	/* Enable the GPIOA clock ------------------------------------------------*/
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);

	/* Configure button pins as input pull down ------------------------------*/
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin = BUTTONS_LeftRed | BUTTONS_LeftBlack | BUTTONS_RightBlack | BUTTONS_RightRed;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;
	GPIO_Init(GPIOA, &GPIO_InitStructure);
}
